#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "../factor.h"

#define RUN_TIMES	5
#define HOST	"140.113.88.148"

int main()
{
	int i;
	float diff_time;
	float value[RUN_TIMES];
	struct timespec start;
	struct timespec stop[RUN_TIMES];

	clock_gettime(CLOCK_MONOTONIC, &start);
	for (i=0; i<RUN_TIMES; i++) {
		value[i] = collect_bandwidth(HOST);
		clock_gettime(CLOCK_MONOTONIC, &stop[i]);
	}

	printf(" No     Time      Bandwidth\n\n");
	for (i=0; i<RUN_TIMES; i++) {
		diff_time = ((float)(stop[i].tv_sec-start.tv_sec))*1000*1000*1000
						+ (stop[i].tv_nsec-start.tv_nsec);
		printf("%3d %.2f %f\n", i, diff_time, value[i]);
	}

	return 0;
}

